% Split Vector Quantization
% ==========================================================================
%  ReconstructionLvls = svq_lvls(VECTORS,CoeffGroups,GroupBits)
% 
%  Description: This function is used to determine the reconstruction levels
%  for split vector quantization. The levels returned are determined using a
%  fast implementation of the k-means algorithm. The used must specify how
%  the vector is to be split and how many bits to allocate to each group.
% 
%  Input Arguments:
% 	Name: VECTORS
% 	Type: matrix (vector length x number of vectors)
% 	Description: a series of training vectors which are used to deterimine
% 	the reconstuction levels
% 
% 	Name: CoeffGroups
% 	Type: cell array
% 	Description: A 1xN cell array in which the n'th cell contains a list of
% 	coeffecients that are elements of the n'th group.
% 
% 	Name: GroupBits
% 	Type: vector
% 	Description: a 1xN vector containing the number of bits the n'th group
% 	is to be coded with.
% 
%  Output Arguments:
% 	Name: ReconstructionLvls
% 	Type: cell array 
% 	Description: A 1xN cell array in which the n'th cell contains the
% 	reconstruction levels of the n'th group. 
% 
%  References:
% 
% --------------------------------------------------------------------------
%  Notes: This function requires the fast k-mean implementation by Charles
%  Elkan.
% 
%  
% 
% --------------------------------------------------------------------------
%  Author: Steven Sandoval
% 
%  Creation Date: June 2011
% 
% --------------------------------------------------------------------------
%  Revision History:
%  
% 
% ==========================================================================
%
